"""
LetMeDoIt AI Plugin - search financial data

search financial data with yfinance

[FUNCTION_CALL]
"""

from myhand import config
from myhand.utils.shared_utils import SharedUtil
import json

def search_finance(function_args):
    code = function_args.get("code") # required
    information = SharedUtil.showAndExecutePythonCode(code)
    if information:
        info = {
            "information": information,
        }
        return json.dumps(info)
    return ""

functionSignature = {
    "name": "search_finance",
    "description": f'''Search or analyze financial data. Use this function ONLY WHEN package yfinance is useful to resolve my request''',
    "parameters": {
        "type": "object",
        "properties": {
            "code": {
                "type": "string",
                "description": "Python code that integrates package yfinance to resolve my request. Integrate package matplotlib to visualize data, if applicable.",
            },
        },
        "required": ["code"],
    },
}

config.pluginsWithFunctionCall.append("search_finance")
config.chatGPTApiFunctionSignatures.append(functionSignature)
config.chatGPTApiAvailableFunctions["search_finance"] = search_finance